/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Test Routines for SDIO cards on DM814X EVM.
 *
 */

#include <stdio.h>
#include "uart.h"
#include "bluetooth.h"

#define TI_MANF_ID		0x000D

INT32 bluetooth_test(void *testargs)
{
	platform_write("\n******************************\n\r");
	platform_write(  "         Bluetooth Test       \n\r");
	platform_write(  "******************************\n\r");
	UART_Handle handle;
	UINT32 manfid;
	INT32 err;

	//BTInit();
	if (dm388_evm_bt_init() != SUCCESS)
	{
		platform_write ("BT TEST: Unable to initialise BT Chip\n");
		platform_write ("BT TEST Failed\n");
		return -1;
	}

	handle = _UART_open(UART_2, 26); /* 1152000 BAUD */
	UART_EnableHWFlowCntl (handle);

	platform_write("\nRunning BT Chip Detect Test\n");
	err = get_btchip_version (handle, &manfid);
	if (!err) {
		if (manfid == TI_MANF_ID) {
			platform_write ("Detected a Texas Instruments BT Chip\n");
			platform_write ("BT Chip Detect Test Passed\n");
			platform_write ("\nBluetooth Test Passed!\n");
		}
		else
		{
			platform_write ("Detected a BT chip with a ID = 0x08%x\n", manfid);
		}

	} else
	{
		platform_write ("BT Test Failed: Unable to communicate with the BT Chip\n");
		platform_write ("\nBluetooth Test Failed!\n");
	}
	platform_write("\nBluetooth Test Completed!!\n");
	platform_write("-----------x----------");
	return 0;
}



